function [SpecdB,f]=CalculateSpectrum(P, fs);

if (nargin < 2)
    if (nargin < 1)
        error('CalculateSpectrum','Must provide an input signal')
    end
    fs = 44100;
end

% Calculate frequency vector
f=([0:1:length(P)/2-1]/length(P))*fs;

% Calculate spectrum
Spec_amplitude=fft(P);
SpecdB=20*log10(abs(Spec_amplitude(1:length(f))));


