function y = ApplyCompressor(x,th,ratio)

% function OutputSignal=ApplyCompressor(InputSignal,Threshold,Ratio)
%
% This function employs a technique called gain reduction
% to compress the dynamic range of the InputSignal
% samples, using the following parameters:
%
%  Threshold: the signal level at which the gain reduction begins
%  Ratio: the amount of gain reduction applied past the threshold.

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 18/05/2005.

% Check the required input arguments.
if (nargin < 3)
  error('Not enough input arguments.')
end

% First, apply normal unity gain.
y = x;

% Find sequence values larger than the threshold level.
idx = find(abs(x)>th);

% Apply the ratio-to-1 compression for levels above the threshold.
y(idx) = ((abs(x(idx))-th)/ratio + th).*sign(x(idx));
