function [PCMSignal]=DigitalSineWave(M,fu,more_periods);

% function [PCMSine]=DigitalSineWave(NormalizedAmplitude,SineFrequency,more_periods)
%
% This function generates a PCM digital sinewave signal with
% normalized amplitude equal to NormalizedAmplitude and
% frequency equal to SineFrequency. The length of the waveform
% generated is equal to it's fundamental period in samples.
% If a longer sinewave duration is needed, set the more_periods
% input parameter accordingly (>=1).

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 22/03/2005.


% Initialization
down_limit=-32768;
up_limit=32767;
PCMSignal=[];

% Input Parameters Module
prompt={'Enter the sampling frequency (Hz) of the discrete-time sinewave','Enter the PCM resolution','Signed Values'};
def={'44100','16','Yes'};
dlgTitle='PCM Sinewave generator parameters';
lineNo=1;
AddOpts.Resize='off';
AddOpts.WindowStyle='normal';
AddOpts.Interpreter='tex';
Answer=inputdlg(prompt,dlgTitle,lineNo,def,AddOpts);
% Cancel Button is pressed
if (isempty(char(Answer)))
   clc;
   disp('Operation canceled by the user.');
   return   
end

t0=clock;

fs=str2num(char(Answer(1)));
N=str2num(char(Answer(2)));
Type_of_conversion=char(Answer(3));

% Find the fundamental frequency fo and the parameters c,d
[c,d,fo]=find_fo(fs,fu);
npoints=d*more_periods;

% Create the initial No R-O/S discrete-time, tone-like signal
if (Type_of_conversion(1,1)=='Y')
   % Quantize the discrete-time, tone-like signal
   InitSignal=singen(M*up_limit,fu,fs,npoints);
	PCMSignal=QuantiseAudio(InitSignal,N,up_limit,down_limit,0,0);
else
   InitSignal=singen(M*65535,fu,fs,npoints);
   InitSignal=(InitSignal+(up_limit-down_limit))/2;
   % Quantize the discrete-time, tone-like signal
   PCMSignal=QuantiseAudio(InitSignal,N,65535,0,0,0);
end

clc;

t1=clock;
t=(t1-t0)*[0 0 86400 3600 60 1]';
s=sprintf('Sinewave vector succesfully returned. Elapsed time %7.2f seconds',t);
disp(s)
