function [x]=GuitarDistortion(a,x)

% [Output] = GuitarDistortion(A, x) 
%
% This function creates a distortion effect like that
% of an overdriven guitar amplifier. This is a Matlab 
% implementation of an algorithm that was found on 
% www.musicdsp.org.
%
%   A = The amount of distortion. It
%       should be chosen so that -1<A<1.
%   x = Input.  Should be a column vector 
%       between -1 and 1.

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 17/05/2005.

k = 2*a/(1-a);
x = (1+k)*(x)./(1+k*abs(x));

