function [OSSignalWithZeros]=InterpolateZeros(InputSignal,R);

% function [OSSignalWithZeros] = InterpolateZeros(InputSignal,R)
%
% This function adds R-1 zeros between the original InputSignal 
% digital samples. It can be used for performing xR oversampling
% (prior to FIR filtering and requantization)

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 22/03/2005.

% Check the format (line/column vector) of the input signal
[a1 b1]=size(InputSignal);
if (b1>a1)
   % Make the InputSignal a signle column vector
   InputSignal=InputSignal';
end

% First create the appropriate zero-padding matrix
padding_matrix=[1];
for i=1:R-1,
    padding_matrix=[padding_matrix;0];
end

% Now calculate the kronecker product of the input signal
% with the calculated zero-padding_matrix
OSSignalWithZeros = kron(InputSignal,padding_matrix);
