function y = RingModulator(x,A,f)

% function OutputSignal=RingModulator(InputSignal,A,f)
%
% This function employs a technique called gain reduction
% to compress the dynamic range of the InputSignal
% samples, using the following parameters:
%
%  A: modulator amplitude (e.g. A=1)
%  f: modulator frequency in Hz (e.g. f=200Hz)

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 18/05/2005.

% Check the required input arguments.
if (nargin < 3)
  error('Not enough input arguments.')
end

t=[0:1/44100:(length(x)-1)/44100];
m=A*sin(2*pi*f*t);
y=x.*m;