function [SD_bits,SD_time]=SigmaDeltaStream(S);

% function [SDBitStream,SD_time_vector]=SigmaDeltaStream(PCMdata)
%
% This function calculates the 1-bit first order Sigma Delta
% bitstream that corresponds to the input PCMdata samples
  
%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 10/04/2005.

% Initialization
A=32767;
npoints=max(size(S));
d=npoints;
D=32767;
SD_bits=[];
SD_time=[];

% Input must be a row vector
size_matrix=size(S);
if (size_matrix(1)==1),
   S=S';
end

% Input Parameters Module
prompt={'Enter the initial sampling frequency (Hz) of the input PCM data:','Enter the Oversampling factor of PCM-to-S/D Conversion:'};
def={'44100','32'};
dlgTitle='PCM-to-Sigma/Delta Time Mapping Parameters';
lineNo=1;
AddOpts.Resize='off';
AddOpts.WindowStyle='normal';
AddOpts.Interpreter='tex';
Answer=inputdlg(prompt,dlgTitle,lineNo,def,AddOpts);
% Cancel Button is pressed
if (isempty(char(Answer)))
   disp('Operation Canceled');
   return   
end

fs=str2num(char(Answer(1)));
Rd=str2num(char(Answer(2)));
f_sd=Rd*fs;


t0 = clock;
% S-D Modulation Process
  I=[0];
  d_l=[1];
  for l=2:1:d,
     I(l)=S(l-1)-d_l(l-1)*D+I(l-1);
     if (I(l-1)>=0),
        d_l(l)=1;
     else 
        d_l(l)=-1;
     end
  end
  SD_bits=d_l*A;
  SD_bits=SD_bits';
  
% Calculate time vectors
PCMSignal=S(1:Rd:max(size(S)));
temp_mat=ones(Rd,1);
PCMSignal=kron(PCMSignal,temp_mat);
PCMSignal=PCMSignal(1:1:(max(size(PCMSignal))));
SD_time=[0:1/f_sd:(npoints-1)/f_sd]';
if (max(size(PCMSignal))>max(size(SD_time))),
   PCMSignal=PCMSignal(1:1:max(size(SD_time)));
end

% Plot the results
  figSDSpec=figure( ...
	 'Name','PCM-to-Sigma/Delta Conversion Time Representation',...
	 'NumberTitle','off',...
    'MenuBar','none',...
    'PaperOrientation','Landscape');
  figSDaxis=axes( ...
    'Units','normalized',...
    'Position',[0.1 0.3 0.85 0.62],...
    'Visible','on',...
    'FontSize',8,...
    'Xcolor',[0 0 0],...
    'YColor',[0 0 0]);
  txtHndl1=uicontrol( ...
     'Style','frame',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 0],...
     'Units','normalized',...
     'Position',[0.1 0.05 0.85 0.15]);
  txtHndl2=uicontrol( ...
     'Style','text',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 1],...
     'FontSize',[6],...
     'Units','normalized',...
     'String','Andreas Floros, AudioGroup, University of Patras',...
     'HorizontalAlignment','center',...
     'Enable','off',...
     'Position',[0.11 0.002 0.83 0.04]);
  txtHndl3=uicontrol( ...
     'Style','text',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 0],...
     'FontSize',[6],...
     'Units','normalized',...
     'String',' ',...
     'HorizontalAlignment','center',...
     'Enable','on',...
     'Position',[0.11 0.06 0.83 0.04]);


% Ploting  
stairs(SD_time*1e03,SD_bits/32768,'b-');
set(figSDaxis,'Xlim',[0 max(SD_time)*1e03],'Ylim',[-1.2 1.2]);
grid on
xlabel('Time - msec');
ylabel('Normalised Amplitude');
title('Theoretical Sigma/Delta Bit-stream');
hold on
stairs(SD_time*1e03,(PCMSignal/32768),'m-');
clc;

t1=clock;
t=(t1-t0)*[0 0 86400 3600 60 1]';
s=sprintf('Vectors SD_bits, SD_time succesfully returned. Elapsed time %7.2f seconds',t);
set(txtHndl3,'String',s);
zoom xon
