function [c,d,fo]=find_fo(fs,fu);

% function [c,npoints,fo]=find_fo(fs,fin)
% This function calculate the fundamental frequency fo of a
% discrete time sinewave signal with frequency fin, sampled at
% fs (Hz). The number of samples (npoints) that correspond to
% the fundamental period are also calculated. The output parameter
% c contains the index of the spectral coefficient that corresponds
% to the sinewave frequency fin.

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 22/03/2005.

%Initialization
d=1;

% Find the first possible integer
while (fs/d>fu),
  d=d+1;
end

pos_d=[d:1:d+40000];
[M,N]=size(pos_d);
pos_fo=(ones(M,N)*fs)./pos_d;

pos_c=(ones(M,N)*fu)./pos_fo;

diafora=pos_c-floor(pos_c);

i=find(diafora==0);
i=min(i);
c=pos_c(i);
d=pos_d(i);
fo=fs/d;



  
