function sinwave=singen(Ao,fo,fs,npoints);

% function Sinewave=singen(Amplitude,fin,fs,npoints).
%
% This function generates a discrete time sinewave signal with
% Amplitude A and frequency fin (Hz). The sampling frequency
% equals to fs (Hz). The total number of the generated sinewave
% samples equals to npoints.

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 22/03/2005.

t=[0:1/fs:(npoints/fs)-(1/fs)];
sinwave=Ao*sin(2*pi*fo*t);
sinwave=sinwave';

