function y = ApplyExpander(x,th,ratio)

% function OutputSignal=ApplyExpander(InputSignal,Threshold,Ratio)
%
% This function employs a technique called gain increment
% to expand the dynamic range of the InputSignal
% samples, using the following parameters:
%
%  Threshold: the signal level at which the gain is increased
%  Ratio: the amount of amplification applied past the threshold.

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 18/05/2005.

% Check the required input arguments.
if (nargin < 3)
  error('Not enough input arguments.')
end

% First, apply normal unity gain.
y = x;

% Find sequence values larger than the threshold level.
idx = find(abs(x)<th);

% Apply the ratio-to-1 expansion for levels above the threshold.
y(idx) = ((abs(x(idx))-th)/ratio + th).*sign(x(idx));
