function [THD_NOISE]=CalcTHDN(InSpectrum,freq,c);

% function [THDN] = CalcTHDN(InputSpectrum,FrequencyVector,SineFrequency)
%
% This function calculates the Total Harmonic Doistortion+Noise (THD+N)
% for a sinewave signal, using the equation:
%
%		        spurious harmonic power
%	   THD_NOISE = -------------------------
%			     total power
%
% The input argument c represents the index of the spectral coefficient
% that corresponds to the input sinewave frequency.

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 22/03/2005.


% Find the audible frequency region
  i=find(freq<20000);

% Find the power of each frequency component in audible region
  InSpectrum=InSpectrum(i);
  InSpectrum=InSpectrum.^2;

% Calculate the total spectral power
  den=sum(InSpectrum)-InSpectrum(1);

% Calculate the spurious spectral power
  num=den-InSpectrum(c+1);

% Final calculation of THD_NOISE parameter
  THD_NOISE=(num/den);
