function [SignalSpectrumdB,f]=CalculateSpectrum(InputSignal);

% function [SignalSpectrumdB,f]=CalculateSpectrum(InputSignal)
%
% This function calculates the spectrum amplitude (in dB)
% of the digital InputSignal as a function of frequency f.
% It also plots the calculated spectrum vs frequency.

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 22/03/2005.

% Check input arguments
if (nargin~=1),
   error('This function requires 2 input arguments, operation aborded');
end

% Input Parameters Module
prompt={'Enter the sampling frequency (Hz) of the input PCM data:','Enter the Input sinewave frequency in Hz (0 for non-tone input):'};
def={'44100','0'};
dlgTitle='Digital Signal Spectrum Calculation';
lineNo=1;
AddOpts.Resize='off';
AddOpts.WindowStyle='normal';
AddOpts.Interpreter='tex';
Answer=inputdlg(prompt,dlgTitle,lineNo,def,AddOpts);

% Cancel Button is pressed
if (isempty(char(Answer)))
   clc;
   disp('Operation canceled by the user.');
   return   
end
fs=str2num(char(Answer(1)));
fin=str2num(char(Answer(2)));

% Calculate the input signal amplitude in dB
SignalSpectrum=fft(InputSignal);
SignalSpectrumdB=20*log10(abs(SignalSpectrum));

% Get the number of points of the spectrum
npoints=length(SignalSpectrum);

% Create the appropriate frequency resolution vector up to fs/2
f=fs*[0:1:npoints/2-1]/npoints;

% Truncate the signal spectrum up to the fs/2
SignalSpectrumdB=SignalSpectrumdB(1:length(f));
SignalSpectrum=SignalSpectrum(1:length(f));

% Plot the results
  figSignalSpec=figure( ...
	 'Name','PCM Signal spectrum',...
	 'NumberTitle','off',...
    'MenuBar','none',...
    'PaperOrientation','Landscape');
  figSignalSpecaxis=axes( ...
    'Units','normalized',...
    'Position',[0.1 0.3 0.85 0.62],...
    'Visible','on',...
    'FontSize',8,...
    'Xcolor',[0 0 0],...
    'YColor',[0 0 0]);
 
 txtHndl1=uicontrol( ...
     'Style','frame',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 0],...
     'Units','normalized',...
     'Position',[0.1 0.05 0.85 0.15]);
  
  if (fin~=0),

  txtHndl2=uicontrol( ...
     'Style','text',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 1],...
     'Units','normalized',...
     'String','1st Even Harmonic:',...
     'HorizontalAlignment','center',...
     'Position',[0.11 0.11 0.83 0.04]);
  end


txtHndl4=uicontrol( ...
     'Style','text',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 1],...
     'FontSize',[6],...
     'Units','normalized',...
     'String','Andreas Floros, AudioGroup, University of Patras',...
     'HorizontalAlignment','center',...
     'Enable','off',...
     'Position',[0.11 0.002 0.83 0.04]);
txtHndl5=uicontrol( ...
     'Style','text',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 1],...
     'FontSize',[8],...
     'Units','normalized',...
     'String','Unknown input type waveform, no THD analysis performed...',...
     'HorizontalAlignment','center',...
     'Visible','off',...
     'Position',[0.11 0.11 0.83 0.04]);
txtHndl6=uicontrol( ...
     'Style','text',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 0],...
     'FontSize',[6],...
     'Units','normalized',...
     'String',' ',...
     'HorizontalAlignment','center',...
     'Enable','on',...
     'Position',[0.11 0.06 0.83 0.04]);

plot(f,SignalSpectrumdB,'linestyle','-','color','b','linewidth',1.3);
yl=get(figSignalSpecaxis,'Ylim');
set(figSignalSpecaxis,'Xlim',[0 max(f)],'Ylim',[yl(1) yl(2)]);
grid on
xlabel('Frequency (Hz)');
ylabel('Amplitude (dB)');
title('Signal Spectrum (dB)');

if (fin~=0),
	% Find the fundamental frequency fo and the parameters c,d
   [c,d,fo]=find_fo(fs,fin);
   [THD_NOISE]=CalcTHDN(SignalSpectrum,f,c);
	s=sprintf('THD+N=%5.3fdB',10*log10(THD_NOISE));
   set(txtHndl2,'String',s);
else
   set(txtHndl5,'Visible','on');
end

clc;


