function [PWM_bits,PWM_time]=DPWMStream(PCMdata);

% function [PWM_bits,t]=DPWMStream(PCMdata)
%
% This function calculates the class D 1-bit PWM stream  representation
% of the input PCMdata. Note that these samples must be unsigned integers
% in the range [0, 65535]

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Audio Group, WCL, University of Patras
%  Last Modified: 10/04/2005.

% Initialization
up_limit=65535;
down_limit=0;
Umax=up_limit-down_limit;
A=Umax;
npoints=max(size(PCMdata));
PWM_bits=[];
PWM_time=[];

% Input PCMSignal range conditioning
min_PCMdata=min(PCMdata);
if (min_PCMdata<0),
   clc;
   disp('Input PCM data should be in the region [0 65535]');
   disp('Operation canceled.');
   return
end

% Input Parameters Module
prompt={'Enter the sampling frequency (Hz) of the input PCM data:','Enter the bit resolution of the input PCM data'};
def={'44100','8'};
dlgTitle='PCM-to-PWM Time Mapping Parameters';
lineNo=1;
AddOpts.Resize='off';
AddOpts.WindowStyle='normal';
AddOpts.Interpreter='tex';
Answer=inputdlg(prompt,dlgTitle,lineNo,def,AddOpts);
% Cancel Button is pressed
if (isempty(char(Answer)))
   clc;
   disp('Operation canceled by the user.');
   return   
end
fs=str2num(char(Answer(1)));
N=str2num(char(Answer(2)));

% Allowed PWM resolution 
if (N>9),
   clc;
   disp('Hard disk capacity can afford PWM resolutions for N>9');
   disp('Operation canceled.');
   return
end 


t0=clock;

PWM_bits=[];

LSB=Umax/(2^N-1);

for i=1:1:npoints,
  num_ones=PCMdata(i)/LSB;
  add_ones=ones(2*num_ones,1);
  add_zeros=zeros(((2^N-1)-num_ones),1);
  PWM_bits=[PWM_bits;add_zeros;add_ones;add_zeros];
end

PWM_bits=PWM_bits*Umax;
PWM_bits=PWM_bits-32768;

% Calculate time vactors
PCM_time=[0:1/fs:(npoints-1)/fs];
f_pwm=2*(2^N-1)*fs;
PWM_time=[0:1/f_pwm:(2*(2^N-1)*npoints-1)/f_pwm]';

% Plot the results
  figPWMSpec=figure( ...
	 'Name','PCM-to-PWM (class D) Conversion Time Representation',...
	 'NumberTitle','off',...
    'MenuBar','none',...
    'PaperOrientation','Landscape');
  figPWMaxis=axes( ...
    'Units','normalized',...
    'Position',[0.1 0.3 0.85 0.62],...
    'Visible','on',...
    'FontSize',8,...
    'Xcolor',[0 0 0],...
    'YColor',[0 0 0]);
 
  txtHndl1=uicontrol( ...
     'Style','frame',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 0],...
     'Units','normalized',...
     'Position',[0.1 0.05 0.85 0.15]);
  txtHndl2=uicontrol( ...
     'Style','text',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 1],...
     'FontSize',[6],...
     'Units','normalized',...
     'String','Andreas Floros, AudioGroup, University of Patras',...
     'HorizontalAlignment','center',...
     'Enable','off',...
     'Position',[0.11 0.002 0.83 0.04]);
  txtHndl3=uicontrol( ...
     'Style','text',...
     'BackGroundColor',[0.8 0.8 0.8],...
     'ForeGroundColor',[0 0 0],...
     'FontSize',[6],...
     'Units','normalized',...
     'String',' ',...
     'HorizontalAlignment','center',...
     'Enable','on',...
     'Position',[0.11 0.06 0.83 0.04]);

    
plot(PWM_time*1e03,PWM_bits/32768,'linestyle','-','color','b','linewidth',1);
set(figPWMaxis,'Xlim',[0 max(PWM_time)*1e03],'Ylim',[-1.2 1.2]);
grid on
xlabel('Time - msec');
ylabel('Normalised Amplitude');
title('Theoretical 1-bit class D PWM Pulse Stream');
hold on
stairs(PCM_time*1e03,((PCMdata-32768)/32768),'m-');
clc;

t1=clock;
t=(t1-t0)*[0 0 86400 3600 60 1]';
s=sprintf('Vectors PWM_bits, PWM_time succesfully returned. Elapsed time %7.2f seconds',t);
set(txtHndl3,'String',s);
zoom xon

