function [PCMSignal]=CreateSineWave(M,fu);

% function [PCMSignal]=CreateSinewave(Normalised_Amplitude,f_sinewave);
%
% Digital Sine Waveforms Generator
%   
% Andreas Floros
% WCL, Audio Group
% Last Modified: 20/12/1999.


% Initialization
down_limit=-32768;
up_limit=32767;
PCMSignal=[];

t0=clock;

fs=44100;
N=16;

% Find the fundamental frequency fo and the parameters c,d
[c,d,fo]=find_fo(fs,fu);
npoints=d*2;

% Create the initial No R-O/S discrete-time, tone-like signal
% Quantize the discrete-time, tone-like signal
InitSignal=singen(M*up_limit,fu,fs,npoints);
PCMSignal=quant(InitSignal,N,up_limit,down_limit,0,0);

clc;

t1=clock;
t=(t1-t0)*[0 0 86400 3600 60 1]';
s=sprintf('Sinewave vector succesfully returned. Elapsed time %7.2f seconds',t);
disp(s)