%  An amplitude panning demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 24/03/2009.

clc;
clear;

% The next variable is used for calculating the number
% of the processed sound sources
num_of_sources = 0;

% Load the original recordings
[guitar1, fs, N] = wavread('guitar_1.wav');
[guitar2, fs, N] = wavread('guitar_2.wav');
[vocals, fs, N] = wavread('vocals.wav');
[drums, fs, N] = wavread('drums.wav');
[bass, fs, N] = wavread('bass.wav'); 

% GUITAR 1 PROCESSING
% Define the relative to the left speaker angle
theta_left = 20;
% Perform linear stereo panning
y_guitar1 = Fx_AmplitudePanning(guitar1, theta_left);
num_of_sources = num_of_sources + 1;

% GUITAR 2 PROCESSING
% Define the relative to the left speaker angle
theta_left = 70;
% Perform linear stereo panning
y_guitar2 = Fx_AmplitudePanning(guitar2, theta_left);
num_of_sources = num_of_sources + 1;

% VOCALS PROCESSING
% Define the relative to the left speaker angle
theta_left = 45;
% Perform linear stereo panning
y_vocals = Fx_AmplitudePanning(vocals, theta_left);
num_of_sources = num_of_sources + 1;

% DRUMS PROCESSING
% Define the relative to the left speaker angle
theta_left = 33;
% Perform linear stereo panning
y_drums = Fx_AmplitudePanning(drums, theta_left);
num_of_sources = num_of_sources + 1;

% BASS PROCESSING
% Define the relative to the left speaker angle
theta_left = 60;
% Perform linear stereo panning
y_bass = Fx_AmplitudePanning(bass, theta_left);
num_of_sources = num_of_sources + 1;

% Perform mixing
% First define the mixing weights
w = 1;
mixing_weights = ones(num_of_sources , 1) * w;

% Total left channel mixing
% Create the corresponding data structure
left_channel_data = [y_guitar1(:,1) y_guitar2(:,1) y_vocals(:,1) y_drums(:,1) y_bass(:,1)];
% Perform mixing
y_left = Fx_WeightedMix(left_channel_data, mixing_weights);

% Total right channel mixing
% Create the corresponding data structure
right_channel_data = [y_guitar1(:,2) y_guitar2(:,2) y_vocals(:,2) y_drums(:,2) y_bass(:,2)];
% Perform mixing
y_right = Fx_WeightedMix(right_channel_data, mixing_weights);

% Create the final stereo wav structure
y_stereo = [y_left y_right];

% Save to a wave file
wavwrite(y_stereo, fs, N, 'final.wav');

