function y_mixed = Fx_WeightedMix(x, mixing_weights)

% function OutputSignal = Fx_WeightedMix(x, mixing_weights)
%
% This function implements weighted mixing of signals
% stored in column-based data x using the weigth values
% contained in column vector mixing_weights.

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 22/03/2009.

% Check the required input arguments.
if (nargin < 2)
  error('Not enough input arguments.')
end

% Initially set the mixed output to zero
y_mixed = zeros(max(size(x)),1);

% Calculate the number of signals to mix
num_of_tracks_to_mix = length(mixing_weights);

% Finally, perform weighted mix
for i = 1: num_of_tracks_to_mix,
    y_mixed = y_mixed + mixing_weights(i) * x(:,i);
end

y_mixed = y_mixed ./ sum(mixing_weights); 

