function y_Stereo = Fx_AmplitudePanning(x, theta_left)

% function y_Stereo = Fx_AmplitudePanning(x, theta_left)
%
% This function implements the amplitude panning technique,
% using the following parameters:
%
% theta_left: Should be in the range [0...90]
% It denotes the absolute angle value between the left loudspeaker
% and the sound source image. The loudspeakers angle is 90 degrees. 

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 22/03/2009.

% Check the required input arguments.
if (nargin < 2)
  error('Not enough input arguments.')
end

% Convert angles in radians
theta_right = ( (90 - theta_left) / 360 ) * 2 * pi;
theta_left = (theta_left / 360)* 2 * pi;

% Calculate the corresponding panning gains
R_Gain = cos(theta_right);
L_Gain = cos(theta_left);

% Apply panning gains
y_Left = L_Gain * x;
y_Right = R_Gain * x;

y_Stereo = [y_Left y_Right];

