%  Aliasing Demo

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 20/02/2009.

clc;
clear;

fs = 44100;                     % Define the sampling frequency (in Hz)
npoints = 441000;                  % Define the total signal duration (equal to 10 seconds)
t = [0 : npoints - 1] / fs;     % Accurate sampling time values (no timing errors)
fin = 5000;                     % Sinewave frequency (in Hz). Can also be 10000, 15000, 20000 and 25000Hz

% Create the sinewave signal (s)
SignalAmplitude = 1;
s = SignalAmplitude * sin(2 * pi * t * fin);

% Calculate the signal spectrum
s_spectrum = fft(s);
s_spectrum_dB = 20*log10(abs(s_spectrum));

% Calculate the appropriate frequency vector (x-axis data)
f = fs * [0 : 1 : npoints/2 - 1] / npoints;

% Now plot the results (only the first 150 samples)
figure
plot(f, s_spectrum_dB(1:npoints/2),'b-');
xlabel('Frequency (Hz)');
ylabel('Amplitude (dB)');
title('Signal Spectrum');

legendString = sprintf('fin=%skHz',num2str(fin/1000))
legend(legendString);