%  Sampling jitter Demo

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 01/03/2009.

clc;
clear;

fs = 44100;                     % Define the sampling frequency (in Hz)
npoints = fs * 10;              % Define the total signal duration (equal to 5 seconds)
t = [0 : npoints - 1] / fs;     % Accurate sampling time values (no timing errors)

% Create the original (non-jittered) sinewave signal (s)
SignalAmplitude = 0.99;
SignalFrequency = 1000;
s = SignalAmplitude * sin(2 * pi * t * SignalFrequency);

% Create the jittered sinewave signal (sjitter) using random jitter
% values with normal distribution
Ts = 1/fs;                      % The sampling period (in seconds)
MaxJitter = Ts / 10;            % The maximum jitter value

% Create the time jittered values
tj = t + ( 2 * rand(1, npoints) - 1) * MaxJitter;

% Calculate the jittered signal samples
sjitter = SignalAmplitude * sin(2 * pi * tj * SignalFrequency);

% Calculate the jitter "error"
e = s - sjitter;

% Calculate jitter error energy
e_energy = sum(e.^2)

% Now plot the results (only the first 150 samples)
figure
plot(t(1:150),s(1:150),'b-');
hold on
plot(t(1:150),sjitter(1:150),'m-');
plot(t(1:150),e(1:150),'g-');
legend('No jitter','With jitter','Jitter error');
plot(t(1:150),s(1:150),'bo');
plot(t(1:150),sjitter(1:150),'mo');

xlabel('Time (seconds)');
ylabel('Normalized amplitude');
title('Aliasing error');


% Save everything to wave files
wavwrite(sjitter, fs, 16, 'JitteredSignal.wav');
wavwrite(s, fs, 16, 'OriginalSignal.wav');
wavwrite(e, fs, 16,'JitterError.wav');