%  Quantisation Error Demo

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 20/02/2009.

clc;
clear;

% Read the input audio data
[ original_audio, fs, N ] = wavread('audio_sample.wav');

% Calibrate the original audio signal smple values
original_audio = original_audio * 32768;

% Perform Quantisation to 8, 4 and 2 bits
audio08 = QuantiseAudio(original_audio, 8 ,32767, -32768 , 0, 0);
audio04 = QuantiseAudio(original_audio, 4 ,32767, -32768 , 0, 0);
audio02 = QuantiseAudio(original_audio, 2 ,32767, -32768 , 0, 0);

% Calculate all the relative quantisation errors
error08 = original_audio - audio08; 
error04 = original_audio - audio04; 
error02 = original_audio - audio02; 

% Calculate the quantization error energy
e_energy_08 = sum(error08.^2)
e_energy_04 = sum(error04.^2)
e_energy_02 = sum(error02.^2)

% Now plot the results (only the first 150 samples)
% First calculate the corresponding time vector
npoints = length( original_audio );
t = [0 : npoints - 1] / fs;

% 16-to-8 bit plot
figure
plot(t(1:150),original_audio(1:150),'b-');
hold on
plot(t(1:150),audio08(1:150),'m-');
plot(t(1:150),error08(1:150),'g-');
legend('16 bit','8 bit','error');
plot(t(1:150),original_audio(1:150),'bo');
plot(t(1:150),audio08(1:150),'mo');
xlabel('Time (seconds)');
ylabel('Linear amplitude');
title('16-to-8 bit quantization');

% 16-to-4 bit plot
figure
plot(t(1:150),original_audio(1:150),'b-');
hold on
plot(t(1:150),audio04(1:150),'m-');
plot(t(1:150),error04(1:150),'g-');
legend('16 bit','4 bit','error');
plot(t(1:150),original_audio(1:150),'bo');
plot(t(1:150),audio04(1:150),'mo');
xlabel('Time (seconds)');
ylabel('Linear amplitude');
title('16-to-4 bit quantization');

% 16-to-2 bit plot
figure
plot(t(1:150),original_audio(1:150),'b-');
hold on
plot(t(1:150),audio02(1:150),'m-');
plot(t(1:150),error02(1:150),'g-');
legend('16 bit','2 bit','error');
plot(t(1:150),original_audio(1:150),'bo');
plot(t(1:150),audio02(1:150),'mo');
xlabel('Time (seconds)');
ylabel('Linear amplitude');
title('16-to-2 bit quantization');