%  Creates a unit function

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

clc;
clear;

% Define the total signal length (in samples)
npoints = 512;

% Define the initial delay (in samples)
initial_delay = 20;

% Create the delta function signal
unit_data = zeros(1,npoints);
unit_data(initial_delay + 1 : 1 : npoints) = 1;

% Plot only the first points of the signal
n=[0:1:initial_delay + 150 - 1];
figure
stem(n, unit_data(1 : 1 : initial_delay + 150) );
xlabel('n (samples)');
ylabel('Amplitude');
title('Unit function');

