function y = Fx_Expander(x,th,ratio)

% function OutputSignal=Fx_Expander(InputSignal,Threshold,Ratio)
%
% This function employs a technique called gain reduction
% to expand the dynamic range of the InputSignal
% samples, using the following parameters:
%
%  Threshold: the signal level at which the gain reduction begins
%  Ratio: the amount of gain reduction applied past the threshold.

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

% Check the required input arguments.
if (nargin < 3)
  error('Not enough input arguments.')
end

% First, apply normal unity gain.
y = x;

% Find sequence values smaller than the threshold level.
idx = find(abs(x)<th);

% Apply the ratio-to-1 expansion for levels below the threshold.
y(idx) = x(idx)/ratio;
