function [x]=Fx_GuitarDistortion(a,x)

% [Output] = Fx_GuitarDistortion(A, x) 
%
% This function creates a distortion effect like that
% of an overdriven guitar amplifier. This is a Matlab 
% implementation of an algorithm that was found on 
% www.musicdsp.org.
%
%   A = The amount of distortion. It
%       should be chosen so that -1<A<1.
%   x = Input.  Should be a column vector 
%       between -1 and 1.

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

k = 2*a/(1-a);
x = (1+k)*(x)./(1+k*abs(x));

