%  Creates a delta function

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

clc;
clear;

% Define the total signal length (in samples)
npoints = 88200;

% Define the initial delay (in samples)
initial_delay = 100;

% Create the delta function signal
delta = zeros(1,npoints);
delta(initial_delay + 1) = 1;

% Plot only the first points of the signal
n=[initial_delay:1:initial_delay + 150 - 1];
figure
stem(n, delta(initial_delay + 1:1:initial_delay + 150) );
xlabel('n (samples)');
ylabel('Amplitude');
title('Delta function');

% Save the delta function to a wave file
% Consider a sampling frequency equal to 44.1kHz
wavwrite(delta, 44100, 'delta.wav');

