% Expander Demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

clc;
clear;

% Read the original audio data
[y, fs, N]=wavread('audio_sample.wav');

% Add some noise to them
y_noisy = y + 0.01 * randn(length(y),1);

% Apply the expander on the noisy signal
th = 0.012;
ratio = 8;
y_expanded = Fx_Expander(y_noisy,th,ratio);

% Create the corresponding plots
figure
plot(y_noisy(1:4000),'b-');
hold on
plot(y_expanded(1:4000),'g-');
legend('noisy','expanded');
xlabel('Samples');
ylabel('Amplitude');
title('Expander Demonstration');