%  Simple gain filter example

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

clc;
clear;

% Read the input audio data
[x, fs, N] = wavread('audio_sample.wav');

% Set the gain G
G = 2;

% Apply normalization to audio sample
y = G .* x;

% Plot only the first points of the signals
n=[0 : 1 : 399];
figure
plot(n, x(1 : 400), 'b-' );
hold on
plot(n, y(1 : 400), 'g-');
legend('input','output');
plot(n, x(1 : 400), 'bo' );
plot(n, y(1 : 400), 'go');
xlabel('n (samples)');
ylabel('Amplitude');
title('Simple Gain Filter Example');

