%  Audio data normalization example

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

clc;
clear;

% Read the input audio data
[y, fs, N] = wavread('audio_sample.wav');

% Calculate the PeakValue
PeakValue  = max(y);

% Set the target normalization value (in the range of 0...1)
TargetValue = 1;

% Calculate the normalization gain G
G = TargetValue / PeakValue;

% Apply normalization to audio sample
normalized_y = G .* y;

% Plot only the first points of the signals
n=[0 : 1 : 399];
figure
plot(n, y(1 : 400), 'b-' );
hold on
plot(n, normalized_y(1 : 400), 'g-');
legend('original','normalized');
plot(n, y(1 : 400), 'bo' );
plot(n, normalized_y(1 : 400), 'go');
xlabel('n (samples)');
ylabel('Amplitude');
title('Normalization example');

