function [y_stereo] = Fx_StereoTremolo(x,A,f,fs)

% function OutputStereoSignal=Fx_Fx_StereoTremolo(InputSignal,A,f,fs)
%
% This function implemets the stereo tremolo effect
% using the following parameters:
%
%  A: panning amplitude (e.g. A=1)
%  f: panning frequency in Hz (e.g. f=200Hz)
% fs: the sampling frequency

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

% Check the required input arguments.
if (nargin < 3)
  error('Not enough input arguments.')
end

t=[0:1/fs:(length(x)-1)/fs];
m=A*sin(2*pi*f*t)';

% Initialize output
y_left = zeros(size(x));
y_right = zeros(size(x));

% Perform tremolo effect
i = find(m > 0 );
y_left(i) = x(i) .* m(i);

i = find(m < 0 );
y_right(i) = x(i) .* m(i);

y_stereo = [y_left y_right];