function y = Fx_RingModulator(x,A,f,fs)

% function OutputSignal=Fx_RingModulator(InputSignal,A,f,fs)
%
% This function implements the ring modulation effect,
% using the following parameters:
%
%  A: modulator amplitude (e.g. A=1)
%  f: modulator frequency in Hz (e.g. f=200Hz)
% fs: the sampling frequency

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 14/03/2009.

% Check the required input arguments.
if (nargin < 3)
  error('Not enough input arguments.')
end

t=[0:1/fs:(length(x)-1)/fs];
m=A*sin(2*pi*f*t);
y=x.*m;