%  An amplitude panning demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 22/03/2009.

clc;
clear;

% Load two different audio files
[y, fs, N] = wavread('AnechoicInstrument.wav');  

% Define the theta angle variable value
thetaVariationStep = 90 / (length (y) - 1);
theta_left = [0 : thetaVariationStep : 90]';

% Convert angles in radians
theta_right = ( (ones(size(theta_left)) * 90 - theta_left) ./ 360 ) .* (2 * pi);
theta_left = (theta_left ./ 360) .* (2 * pi);

% Calculate the corresponding panning gains
R_Gain = cos(theta_right);
L_Gain = cos(theta_left);

% Apply panning gains
y_Left = L_Gain .* y;
y_Right = R_Gain .* y;
y_Stereo = [y_Left y_Right];