function y = Fx_FadeIn(x, window_length, window_type)

% function y = Fx_FadeIn(x, window_length, window_type)
%
% This function implements the Fade-in effect,
% using the following parameters:
%
% window_length: Full length of the applied window (in samples)
% window_type: The window type employed. Can be one between "hamm",
% "hann" and "blac" (for hamming, hanning and blackman windows
% respectively)

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 23/03/2009.

% Check the required input arguments.
if (nargin < 3)
  error('Not enough input arguments.')
end

y = x;

% Create the note, depending on the input type
if (strcmp(window_type,'hamm'))
  w=hamming(window_length);

elseif (strcmp(window_type,'hann'))
  w=hanning(window_length);

elseif (strcmp(window_type,'blac'))
  w=blackman(window_length);
  
else
  error('Unknown window type');
end

% Perform windowing
npoints = window_length / 2;
y(1:npoints) = x(1:npoints) .* w(1:npoints);

