function y_Stereo = Fx_StereoBalance(x, BalanceValue)

% function OutputSignal = Fx_StereoBalance(x, BalanceValue)
%
% This function implements the balance-based stereo panning technique,
% using the following parameters:
%
% BalanceValue: Should be in the range [-1...+1]
% -1 denotes hard left speaker playback
% +1 denotes hard right speaker playback
%  0 places the virtual image source in the center

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 21/03/2009.

% Check the required input arguments.
if (nargin < 2)
  error('Not enough input arguments.')
end

R_Gain = ( 1 + BalanceValue ) / 2;
L_Gain = 1 - R_Gain;

y_Left = L_Gain * x;
y_Right = R_Gain * x;

y_Stereo = [y_Left y_Right];

