%  A Fade-out effect demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 23/03/2009.

clc;
clear;

% Define the Fade-in time length (in samples)
fadeout_length = 16384;

% Load two different audio files
[x, fs, N] = wavread('Rock_unfaded.wav');  

% Apply fade-in
y = Fx_FadeOut(x, fadeout_length, 'hann');

% Plot everything
figure
plot(x( length(x) - fadeout_length - 100 : length(x) ), 'b-');
hold on
plot(y( length(y) - fadeout_length - 100 : length(y)), 'g-');
legend('Original','Faded-out');
title('A Fade-out demonstration');
xlabel('n (samples)');
ylabel('Normalized amplitude');

% Play everything
LoopSound(x,fs,2);
pause;
LoopSound(y,fs,2);