%  A balance-based panning demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 21/03/2009.

clc;
clear;

% Load two different audio files
[x, fs, N] = wavread('AnechoicInstrument.wav');  

% Define the linear panning value
BalanceVariationStep = 2 / (length (x) - 1);
BalanceValue = [-1.0 : BalanceVariationStep : 1]';

% Calculate the corresponding left and right channel gains
G_Right = ( ones(size(BalanceValue)) + BalanceValue ) ./2;
G_Left = ones(size(BalanceValue)) - G_Right;

% Perform linear stereo panning
y_Left = G_Left .* x;
y_Right = G_Right .* x;
y_Stereo = [y_Left y_Right];

