%  A weighted mixing demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 22/03/2009.

clc;
clear;

% Define the number of files to mix
num_of_tracks = 2;

% Load two different audio files
[y1, fs, N] = wavread('FemaleTalk.wav');
[y2, fs, N] = wavread('MaleTalk.wav');

% Set the mixing weights values
w = [0.8; 1 - 0.8 ];

% Convert all input signals to a single matrix
% First make them of the same size
y = [];
y_length = [];
for i = 1 : num_of_tracks,
   y_track = sprintf('y%d',i); 
   eval( ['y_length = [y_length length(' y_track ')];'] );  
end
max_length = max(y_length);

for i = 1 : num_of_tracks,
   y_track = sprintf('y%d',i);
   eval( ['current_track_length = length( ' y_track ' );' ] );
   
   % Perform zero padding here
   if ( current_track_length ~= max_length)
       num_of_zeros_to_pad = max_length - current_track_length;
       eval( [ y_track ' = [ ' y_track ' ; zeros(num_of_zeros_to_pad,1) ]; ' ] );
   end
   
   eval ( ['y = [y ' y_track '];' ] );
end

% Perform weighted mix
y_mixed = Fx_WeightedMix(y, w);