function y = Fx_RMSNormalize(x, TargetRMSValue)

% function OutputSignal = Fx_RMSNormalize(InputSignal, TargetRMSValue)
%
% This function implements RMS normalization,
% using the following parameters:
%
% TargetRMSValue: The target RMS value to normalize (in dB)
% Note that the x signal must be in the [-1...+1] value range 

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 21/03/2009.

% Check the required input arguments.
if (nargin < 2)
  error('Not enough input arguments.')
end

% Calculate the current RMS value
RMS_X_Value = RMS(x);

% Convert the TargetRMSValue to a linear value
TargetRMSValue = 10^(TargetRMSValue / 10);

% Calculate the appropriate normalization gain
Normalization_Gain = TargetRMSValue / RMS_X_Value;

y = Normalization_Gain * x;