function y = SynthesizeSound(amplitudes, frequency, duration, fs)

% Matlab function SynthesizeSound(amplitudes, frequency, duration, fs)
% 
% Creates a sound produced by a fundamental frequency 
% and amplitudes (power) of the harmonics that are specified.
%
% duration is the duration of the produced signal in seconds
% amplitudes is a length n vector of the harmonic amplitudes
%
% Example:
% SynthesizeSound([1 .8 .1 .04], 220, 3, 44100 )
% makes a 3 second sample at 220 Hz with the harmonics shown.

%  Author: Andreas Floros
%  Dept. of Audiovisual arts, Ionian University
%  Last Modified: 24/11/2006.

% Define the sampling frequency and bit resolution of the output wave file
N = 16;
Ts = 1/fs;

% Create the time vector
t = [0: Ts : duration];

% Create the synthesized sound
y = zeros( size(t) );

for i = 1 : length(amplitudes),
  y = y + amplitudes(i)*sin(2 * pi * i * frequency * t);
end