function y = SynthesizeWave(freq,dur,amp,Fs,type)

% function y = SynthesizeWave(freq,dur,amp,Fs,type)
%
% Synthesize a single note
%
% Inputs:
%  freq - frequency in Hz
%  dur - duration in seconds
%  amp - Amplitude in range [0,1]
%  Fs -  sampling frequency in Hz
%  type - string to select synthesis type
%         current options: 'fm', 'sine', or 'saw'

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 23/03/2009.

% Check the number of input arguments
if nargin<5
  error('Five arguments required for synth()');
end

% Calculate the note duration in samples
N = floor(dur*Fs);
n=0:N-1;

% Create the note, depending on the input type
if (strcmp(type,'sine'))
  y = amp.*sin(2*pi*n*freq/Fs);
  y = y';

elseif (strcmp(type,'saw'))

  T = (1/freq)*Fs;     % period in fractional samples
  ramp = (0:(N-1))/T;
  y = ramp-fix(ramp);
  y = amp.*y;
  y = y - mean(y);
  y = y';

elseif (strcmp(type,'fm'))

  t = 0:(1/Fs):dur;
  envel = interp1([0 dur/6 dur/3 dur/5 dur], [0 1 .75 .6 0], 0:(1/Fs):dur);
  I_env = 5.*envel;
  y = envel.*sin(2.*pi.*freq.*t + I_env.*sin(2.*pi.*freq.*t));
  y = y';
  
else
  error('Unknown synthesis type');
end

