%  A Fade-in effect demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 23/03/2009.

clc;
clear;

% Define the Fade-in time length (in samples)
fadein_length = 16384;

% Load two different audio files
[x, fs, N] = wavread('Rock_unfaded.wav');  

% Apply fade-in
y = Fx_FadeIn(x, fadein_length, 'hann');

% Plot everything
figure
plot(x(1: fadein_length + 100), 'b-');
hold on
plot(y(1: fadein_length + 100), 'g-');
legend('Original','Faded-in');
title('A Fade-in demonstration');
xlabel('n (samples)');
ylabel('Normalized amplitude');

% Play everything
LoopSound(x,fs,2);
pause;
LoopSound(y,fs,2);


