%  A simple memory-based system demonstration
%  y(n)= 0.3*x(n) + 0.2*x(n-1) + 0.1*x(n-2)

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 05/04/2009.

clc;
clear;

% Define the input signal
x = zeros(100,1); x(1) = 1; % Impulse signal
% x = [1 ; 0.9 ; 0.8 ; 0.7 ; 0.6 ; 0.5 ; 0.4 ; 0.3 ; 0.2 ; 0.1 ; zeros(90, 1)];

% Define delay parameters
g = 0.5;
T = 2;
DelayLine=zeros(T,1);

for n=1:1:length(x)
   y(n) = x(n) + g * DelayLine(T);
   DelayLine = [x(n); DelayLine(1:T-1)];
end

figure
subplot(1,2,1);stem([0:49],x(1:50));
subplot(1,2,2);stem([0:49],y(1:50));

