%  A simple memory-based system demonstration
%  y(n)= 0.3*x(n) + 0.2*x(n-1) + 0.1*x(n-2)

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 05/04/2009.

clc;
clear;

% Define the system input
%x = [1 0 0 0 0]
x = [1 1 0 0 0];

% The system has a maximum of two samples delay
% Appropriately initialize them to zero values
x_ = [zeros(1,2) x];

% Initialize system output
y = [];

% Now perform calculations
% Note that the n value is now increased by two
% due to zeros initialization above
for n = 3 : 1 : length(x_)
    y_temp = 0.3*x_(n) + 0.2*x_(n-1) + 0.1*x_(n-2);
    y = [y y_temp];
end

% Plot everything
figure
n = [0 : 1 : length(x) - 1];
stem(n, x, 'b');
hold on
stem(n, y, 'g-');
legend('x(n)','y(n)');
title('A simple delay-based system');
xlabel('n (samples)');
ylabel('Normalized amplitude');
grid on