%  A simple interactive-flanger demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 12/05/2009.

clear;
clc;

% Load the input audio signal
[audio_in, fs, N] = wavread( 'audio_sample.wav' );
Ts = 1 / fs;
npoints = max( size( audio_in ) );
duration = npoints * Ts;

% Consider one moving object making a sinewave movement in the x-axis direction

% Define the motion limits
MAX_X = 10;
MAX_Y = 1;
% ... and the motion frequency
f = 500; 

% Now define the motion
% The sampling frequency of the motion is considered equal to fs / 100  
mov_fs = fs / 100;
mov_Ts = 1 / mov_fs; 
x = linspace( 0, MAX_X, duration / mov_Ts);

% Now convert the motion sampling frequency to fs
padding_matrix = ones( npoints / max( size(x) ), 1); 
motion_x_vector = kron(x,padding_matrix');

% and also find the y coordinate
motion_y_vector = MAX_Y * sin( 2 * pi * f * motion_x_vector ); 

% Define the reference point coordinates
ref_X = 5 * ones( size ( motion_x_vector ) );
ref_Y = 0 * ones( size ( motion_y_vector ) );

% Calculate the distance between the moving object and the reference object
XYDistance = sqrt( (ref_X - motion_x_vector).^2 + (ref_Y - motion_y_vector).^2 ); 

% Convert the distance values to flanger depths
Flanger_Depth = 1 - XYDistance / max(XYDistance);

% And finally invoke the ApplyFlanger function. The delay is selected equal to 12msec
flangered_audio = Fx_InteractiveFlanger(audio_in, 12, Flanger_Depth, fs);

% Calculate the two signals difference
error_audio = audio_in - flangered_audio;

% Plot everything
t = [0: Ts : (npoints - 1)*Ts ];
figure
plot(t, audio_in);
hold on
plot(t, flangered_audio, 'g-');
figure
plot(t,error_audio,'m-');



