%  A simple FIR delay-line system demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 05/04/2009.

clc;
clear;

% Define the input signal
[x, fs, N] = wavread ('audio_sample.wav');

% Define delay parameters
g = 0.5;
T = 2;
DelayLine = zeros(T,1);

% Apply the effect
for n=1:1:length(x)
   y(n) = x(n) + g * DelayLine(T);
   DelayLine = [x(n); DelayLine(1:T-1)];
end



