function y = Fx_Equalizer(x,fs,gLP,gBP,gHP)

% function OutputSignal = Fx_Equalizer(InputSignal,fs,gLP,gBP,gHP)
%
% This function implements a simple digital equalizer
% using three FIR filters (LowPass, BandPass and HighPass)
% Use the following parameters:
%
%  InputSignal: the input signal samples
%  fs: the corresponding sampling frequency
%  gLP: the low-frequency band gain
%  gBP: the band-pass gain
%  gHP: the high-pass gain
%
%  Example: gLP=0.4; gBP=1.5; gHP=1.5;

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 12/05/2009.


% Basic Initialization
Wn = .20;
N = 62;

% Create the three filters
LP = fir1(N,Wn);
Wn1 = [.20, .50];
BP = fir1(N,Wn1);
Wn2 = .50;
HP = fir1(N,Wn2,'high');

% Now perform convolution with each one
y1 = conv(LP,x);
y2 = conv(BP,x);
y3 = conv(HP,x);

% Apply per band gains
yA= gHP * y3;
yB= gLP * y1;
yC= gBP * y2;

% Finally add the per band signals
y = yA + yB + yC;
