function [y] = fconv(x, h)

% [y] = fconv(x, h)
% This function performs fast convolution
% of x and h.  The output of this function is
% normalized to +-1.
%
%      x = input vector
%      h = input vector
% 
%      See also CONV

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 12/05/2009.

Ly=length(x)+length(h)-1;   % 
Ly2=pow2(nextpow2(Ly));     % Find smallest power of 2 that is > Ly
m=max(abs(x));      
X=fft(x, Ly2);		          % Fast Fourier transform
H=fft(h, Ly2);		          % Fast Fourier transform
Y=X.*H;        	          % 
y=real(ifft(Y, Ly2));       % Inverse fast Fourier transform
y=y(1:1:Ly);                % Take just the first N elements
m=m/max(abs(y));
y=m*y;