%  A simple room-based reverb demonstration

%  Author: Andreas Floros
%  Digital Audio Processing Applications Group
%  Dept. of Audiovisual Arts, Ionian University
%  v.1.0 - Last Modified: 12/05/2009.

clc;
clear;

% Read the input audio signal
[x, fs, N] = wavread('audio_sample.wav');

% Define the reverb coefficients
rm = [20 19 21];      % Room dimensions
mic = [19 18 1.6];    % The mic position
src = [5 2 1];        % The source position
r = 0.91;             % The reflection coefficients (average)
n = 12;               % The number of virtual sources

% Calculate the reverb filter taps
h = Fx_RoomImpulse(fs, mic, n, r, rm, src);

% Apply the 
y = fconv(x, h);


