function OutputSignal=InteractiveFlanger(InputSignal,Delay,Depth,fs);

% function OutputSignal=ApplyFlanger(InputSignal,Delay,Depth,fs)
%
% This function applies the flanger effect on the InputSignal
% samples, using the following parameters:
%
%  Delay: The flanger delay in milliseconds
%  Depth: The flanger depth
%  fs: The InputSignal sampling frequency (in Hz)

%  Author: Andreas Floros
%  Digital Audio Technology Toolbox
%  Dept. of audiovisual arts, Ionian University
%  Last Modified: 03/12/2006.

% Basic initialization
% Calculate the delay in samples
D = ceil( ( Delay / 1000 ) * fs );

xlen = length( InputSignal );
OutputSignal = zeros( size( InputSignal ) );
delay_effect = zeros( size( InputSignal ) );

% Perform input signal filtering
for i=1:1:D+1,
    OutputSignal(i) = InputSignal(i);
end;

for i = D+1:1:xlen,
    delay_effect(i) = abs( round( D * cos( 2 * pi * i / ( ( xlen-D-1 ) ) ) ) );
    OutputSignal(i) = InputSignal(i) + Depth(i) * InputSignal( i - delay_effect( i ) );
end;
