import ddf.minim.signals.*;
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

import pitaru.sonia_v2_9.*;



Sample mySample;
Minim minim;
AudioInput in;
AudioPlayer audioplayer;

void setup() {
  size(256,200);

  // Initiate Minim
  minim = new Minim(this);
  // get a line in from Minim, default bit depth is 16
  in = minim.getLineIn(Minim.MONO, 512);

  size(512,200);
  Sonia.start(this); // Start Sonia engine.
  // create a new sample object.
  mySample = new Sample("audio_sample.wav"); 
  mySample.repeat();  
}

void draw() 
{ 
  background(0);
  stroke(255);
  
  //SetVolume(); 
  SetRate();
  //SetPan();
}

void SetVolume()
{
  float InstantaneousGain = 0.0;
  
  // Set the master volume
  for(int i = 0; i < in.bufferSize() - 1; i++)
  {
    // Calculate the instantaneous gain
    InstantaneousGain = InstantaneousGain + pow(in.left.get(i), 2.0);
    
    // Draw the instantaneous gain
    line(i, 150 + in.left.get(i)*50, i+1, 150 + in.left.get(i+1)*50);
  }
  
  InstantaneousGain = sqrt(InstantaneousGain);
  println("Gain= "+InstantaneousGain);
  
  // set the master volume to a random number
  mySample.setVolume(InstantaneousGain);
  
  // print the new gain values
  println("Current instantaneous gain:" + InstantaneousGain);
}

void SetRate()
{
   // set the speed (sampling rate) of the sample.
   // Values:
   // 0 -> very low pitch (slow playback).
   // 88200 -> very high pitch (fast playback).
   float rate = ( height - mouseY ) * 88200 / height;
   mySample.setRate( rate );
   
   // print the new gain values
   println("Current rate:" + rate);
}

void SetPan()
{
  // set the pan of the sample object.
  // Range: float from -1 to 1 .... -1 -> left, 0 -> balanced ,1 -> right
  // notes: only works with MONO samples.
  float pan = -1.0 + mouseX / (width / 2.0);
  mySample.setPan(pan);
  
  // print the instantaneous panning value
   println("Panning value:" + pan);
}

void stop()
{
  // Always close Minim and Sonia audio classes when finished
  in.close();
  minim.stop();
  Sonia.stop();
  super.stop();
}
